plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
}

android {
    namespace = "com.example.myapplication"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.example.myapplication"
        minSdk = 26
        targetSdk = 34
        versionCode = 1
        versionName = "1.0"
        multiDexEnabled = true
    }

    // JVM Target hatasını çözen kritik kısım burasıdır
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    kotlinOptions {
        jvmTarget = "11"
    }

    buildFeatures {
        viewBinding = true
        compose = false
    }

    packaging {
        resources {
            // Çakışan dosyaları dışarıda bırakıyoruz
            excludes += "/META-INF/{AL2.0,LGPL2.1,DEPENDENCIES,LICENSE,NOTICE}"
            excludes += "META-INF/INDEX.LIST"
        }
    }
}

dependencies {
    testImplementation("junit:junit:4.13.2")

    // Temel Android Kütüphaneleri
    implementation("androidx.appcompat:appcompat:1.6.1")
    implementation("com.google.android.material:material:1.9.0")
    implementation("androidx.constraintlayout:constraintlayout:2.1.4")

    // İmza Pad kütüphanesi
    implementation("com.github.gcacace:signature-pad:1.3.1")

    // PDF Oluşturma (iText 7)
    implementation("com.itextpdf:itext7-core:7.1.15")

    // Google Drive ve Auth kütüphaneleri
    implementation("com.google.apis:google-api-services-drive:v3-rev20221023-2.0.0")
    implementation("com.google.api-client:google-api-client-android:1.32.1")
    implementation("com.google.auth:google-auth-library-oauth2-http:1.19.0")
    implementation("com.google.api-client:google-api-client-gson:1.32.1")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
    implementation("com.github.gcacace:signature-pad:1.3.1")
}